library(ggplot2)
library(dygraphs)
library(plotly)
library(xts)
library(dplyr)

#TEST1

#raw
getwd()
setwd("C:/Users/smatt/Desktop/R")
JBT05Test1 <- read.csv(file="JBT05Test1.csv", header=TRUE,stringsAsFactors=FALSE)
JBT05Test1$DT<-as.POSIXct(JBT05Test1$DateTime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")
sum(is.na(JBT05Test1$Velocity))
sum(is.na(JBT05Test1$DT))
JBT5AV1<-xts(x=JBT05Test1$Velocity,order.by=JBT05Test1$DT)
dygraph(JBT5AV1)

#tssmooth
JBT05TS1 <- read.csv(file="JBT5TS1_forimport.csv", header=TRUE,stringsAsFactors=FALSE)
JBT05TS1$DT<-as.POSIXct(JBT05TS1$DateTime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")
sum(is.na(JBT05TS1$level))
sum(is.na(JBT05TS1$DT))
JBT5TS1<-xts(x=JBT05TS1$level,order.by=JBT05TS1$DT)
dygraph(JBT5TS1)

#loess
loess1 <- loess(JBT05Test1$Velocity ~ as.numeric(JBT05Test1$DT),span=.08, na.action=na.exclude)
JBT05Test1$loess1<-predict(loess1,JBT05Test1$DT)
JBT5Loess1<-xts(x=JBT05Test1$loess1,order.by=JBT05Test1$DT)
dygraph(JBT5Loess1)

#compare
allsmooths<-cbind(JBT5AV1,JBT5TS1,JBT5Loess1)
dygraph(allsmooths)

#TS SMOOTHING AND EXPORT
#JBT5TS <- subset(JBT05AVMeter, select=c( "DT","Velocity"))
#jbt5TS <- xts(JBT5TS$Velocity, order.by=JBT5TS$DT)
#jbt5TS<-StructTS(jbt5TS)
#jbt5TS<-tsSmooth(jbt5TS)
#write.csv(jbt5TS, "JBT5TS.csv")

#TEST2
#raw
getwd()
setwd("C:/Users/smatt/Desktop/R")
JBT05Test2 <- read.csv(file="JBT05Test1.csv", header=TRUE,stringsAsFactors=FALSE)
JBT05Test2$DT<-as.POSIXct(JBT05Test2$DateTime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")
JBT05Test2$Velo05Test2$DT<city[JBT05Test2$Velocity <= 0] <- NA

sum(is.na(JBT05Test2$Velocity))
sum(is.na(JBT05Test2$DT))
JBT5AV2<-xts(x=JBT05Test2$Velocity,order.by=JBT05Test2$DT)
dygraph(JBT5AV2)

#loess
loess2 <- loess(JBT05Test2$Velocity ~ as.numeric(JBT05Test2$DT),span=0.08, na.acion=na.exclude)
JBT05Test2$loess2<-predict(loess2,JBT05Test1$DT)
sum(is.na(JBT05Test2$loess2))
sum(is.na(JBT05Test2$DT))
JBT5Loess2<-xts(x=JBT05Test2$loess2,order.by=JBT05Test2$DT)
dygraph(JBT5Loess2)


JBT05TS2 <- read.csv(file="JBT5TS2_forimport.csv", header=TRUE,stringsAsFactors=FALSE)
JBT05TS2$DT<-as.POSIXct(JBT05TS$DateTime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")
sum(is.na(JBT05TS2$level))
sum(is.na(JBT05TS2$DT))
JBT5TS2<-xts(x=JBT05TS2$level,order.by=JBT05TS2$DT)
dygraph(JBT5TS2)
allsmooths<-cbind(JBT5AV2,JBT5TS2)
dygraph(allsmooths)

#TS SMOOTHING AND EXPORT
JBT5TS2 <- subset(JBT05Test2, select=c( "DT","Velocity"))
jbt5TS2 <- xts(JBT5TS2$Velocity, order.by=JBT5TS2$DT)
jbt5TS2<-StructTS(jbt5TS2)
jbt5TS2<-tsSmooth(jbt5TS2)
write.csv(jbt5TS2, "JBT5TS2.csv")





#TEST2
getwd()
setwd("C:/Users/smatt/Desktop/R")
JBT05AVMeter <- read.csv(file="JBT05Test2.csv", header=TRUE,stringsAsFactors=FALSE)
JBT05AVMeter$DT<-as.POSIXct(JBT05AVMeter$DateTime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")
library(ggplot2)
library(dygraphs)
library(plotly)
library(xts)
library(dplyr)
JBT5AV<-xts(x=JBT05AVMeter$Velocity,order.by=JBT05AVMeter$DT)
dygraph(JBT5AV)
JBT05AV<-JBT05AVMeter %>% pad('1 min')#fill 1 minute data gaps
sum(is.na(JBT05AVMeter$Velocity))
sum(is.na(JBT05AVMeter$DT))

#TS SMOOTHING AND EXPORT
#JBT5TS <- subset(JBT05AVMeter, select=c( "DT","Velocity"))
#jbt5TS <- xts(JBT5TS$Velocity, order.by=JBT5TS$DT)
#jbt5TS<-StructTS(jbt5TS)
#jbt5TS<-tsSmooth(jbt5TS)
#write.csv(jbt5TS, "JBT5TS.csv")
JBT05TS <- read.csv(file="JBT5TS_forimport.csv", header=TRUE,stringsAsFactors=FALSE)
JBT05TS$DT<-as.POSIXct(JBT05TS$DateTime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")
sum(is.na(JBT05TS$level))
sum(is.na(JBT05TS$DT))
JBT5TS<-xts(x=JBT05TS$level,order.by=JBT05TS$DT)
dygraph(JBT5TS)
allsmooths<-cbind(JBT5AV,JBT5TS)
dygraph(allsmooths)
JBT05TS <- read.csv(file="JBT5TS_forimport.csv", header=TRUE,stringsAsFactors=FALSE)
JBT05TS$DT<-as.POSIXct(JBT05TS$DateTime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")
sum(is.na(JBT05TS$level))
sum(is.na(JBT05TS$DT))
JBT5TS<-xts(x=JBT05TS$level,order.by=JBT05TS$DT)
dygraph(JBT5TS)
allsmooths<-cbind(JBT5AV,JBT5TS)
dygraph(allsmooths)